/* global sc */
/* jshint unused: true */

// load base configuration for agorum core Information Center
let baseFilter = require('/agorum/roi/customers/agorum.composite/js/aguila/acic/settings/base-filter');

// export the configuration
exports.settings = user => { 
  if (!user) user = sc.loginUser;
  
  let baseQuery = baseFilter.baseQuery(user);

  // filter for object types
  function filterConfig() {
    return {
      title: 'isg.xpert.archive Filter',
      name: 'isg_xpert_archive_Filter',
      type: 'query',
      items: [
        {
          title: 'Alle',
          name: 'isg_xpert_archive_FilterAll',
          query: '*'
        }
      ]
    };
  }

  let filter = [];
  filter.push(filterConfig());
  filter.push(baseFilter.objectTypes());
  filter.push(baseFilter.createDate());
  filter.push(baseFilter.lastmodifyDate());
  
  return [
    {
      type: 'configuration',
      name: 'isg_xpert_archive_FilterConfiguration',
      text: 'intecsoft group - xpert - archive',
      filter: filter,
      baseQuery: baseQuery,
      listType: 'detail',
      listTimeline: false,
      favorite: true,
      sort: baseFilter.defaultSort(false)
    }
  ];
};
